/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.structure;

import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.Icon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ElementIcon
extends CustomElement {
    public Icon defaultValue = Icon.valueOf("NONE");
    public boolean allowChange = false;
    public boolean optional = false;
    public int x;
    public int y;
    public int maxWidth = Integer.MAX_VALUE;
    public int maxHeight = Integer.MAX_VALUE;
    public boolean drawUnderlay;
    public int blurRadius;
    public boolean blurDouble;
    public int blurExpand;
    public Color blurColour;
    public Icon.ICON_TYPE iconType;
    public Icon value;

    @Override
    public void drawElement(Graphics2D g) {
        if (this.visible && this.getIconValue().getImagePath() != null) {
            BufferedImage bi = this.getIcon(this.getIconValue(), this.maxWidth, this.maxHeight);
            int xStart = this.x - bi.getWidth() / 2;
            int yStart = this.y - bi.getHeight() / 2;
            if (this.drawUnderlay) {
                this.drawUnderlay(bi, g, 2, xStart, yStart, this.blurRadius, this.blurDouble, this.blurExpand, this.blurColour);
            }
            g.drawImage((Image)bi, xStart, yStart, null);
        }
    }

    public Icon getIconValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return Icon.valueOf("NONE");
    }

    @Override
    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    @Override
    public String generateOutputString(boolean fullExport) {
        String str = "";
        if (this.value != null) {
            str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";value;" + this.value + "\n";
        }
        str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";visible;" + this.visible + "\n";
        return str;
    }
}

